!Object constantsFor: 'Geos Libraries'!

geosLIB66 'SYSTEM\smsed'! !

!Object constantsFor: 'Geos vardata'!

attrTextReadOnly 28160!
attrTextSelectable 28164!
attrSmsEditSetObjectEnabledWhenAddressExists 28168!
attrSmsEditOneAddressLine 28172!
!

!Object constantsFor: 'Geos messages'!

editGetTextContent 28160!
editHiglightText 28161!
editHiglightAddress 28162!
editNormalText 28163!
editGetAddress1Text 28164!
editGetAddress2Text 28165!
editSetAddress1Text 28166!
editSetAddress2Text 28167!
editGetModifiedState 28168!
editCheckTextFormatting 28169!
editHandleFormattingOutput 28170!
editGetReplyPath 28171!
editGetTextSize 28172!
editSetFocusToAddress 28173!
editAppendAddress1Text 28174!
editGetAddress1TextSize 28175!
!

!Geos class methodsFor: 'library calls'!

!

ViewerControl subclass: #SMSEdit
	instanceVariableNames: ''
	classVariableNames: ''!

!SMSEdit comment!
Library smsed, file internal/resp/smsedit.goh! !

!SMSEdit class methodsFor: 'library linkage'!

library
	^66!

entry
	^0004!
!

!SMSEdit methodsFor: 'Geos instance variables'!

!

!SMSEdit methodsFor: 'Geos vardata'!

attrTextReadOnly
	"@vardata void ATTR_TEXT_READ_ONLY"
	^self addVardata: ##attrTextReadOnly!

attrTextSelectable
	"@vardata void ATTR_TEXT_SELECTABLE"
	^self addVardata: ##attrTextSelectable!

attrSmsEditSetObjectEnabledWhenAddressExists: value
	"@vardata ChunkHandle ATTR_SMS_EDIT_SET_OBJECT_ENABLED_WHEN_ADDRESS_EXISTS"
	^self addVardata: ##attrSmsEditSetObjectEnabledWhenAddressExists word: value!

attrSmsEditOneAddressLine
	"@vardata void ATTR_SMS_EDIT_ONE_ADDRESS_LINE"
	^self addVardata: ##attrSmsEditOneAddressLine!

!

!SMSEdit methodsFor: 'Geos messages'!

editGetTextContent: buffer
	"@message word MSG_SMS_EDIT_GET_TEXT_CONTENT(TCHAR *buffer)"
	^self geosMessage: #[110 0 1 0 3 1] with: buffer!

editHiglightText: begin with: end
	"@message void MSG_SMS_EDIT_HIGLIGHT_TEXT(word begin, word end)"
	^self geosMessage: #[110 1 1 0 1 1 0] with: begin with: end!

editHiglightAddress
	"@message void MSG_SMS_EDIT_HIGLIGHT_ADDRESS()"
	^self geosMessage: #[110 2 2 0 0]!

editNormalText
	"@message void MSG_SMS_EDIT_NORMAL_TEXT()"
	^self geosMessage: #[110 3 2 0 0]!

editGetAddress1Text: buffer
	"@message word MSG_SMS_EDIT_GET_ADDRESS1_TEXT(TCHAR *buffer)"
	^self geosMessage: #[110 4 1 0 3 1] with: buffer!

editGetAddress2Text: buffer
	"@message word MSG_SMS_EDIT_GET_ADDRESS2_TEXT(TCHAR *buffer)"
	^self geosMessage: #[110 5 1 0 3 1] with: buffer!

editSetAddress1Text: buffer
	"@message void MSG_SMS_EDIT_SET_ADDRESS1_TEXT(TCHAR *buffer)"
	^self geosMessage: #[110 6 1 0 3 0] with: buffer!

editSetAddress2Text: buffer
	"@message void MSG_SMS_EDIT_SET_ADDRESS2_TEXT(TCHAR *buffer)"
	^self geosMessage: #[110 7 1 0 3 0] with: buffer!

editGetModifiedState
	"@message word MSG_SMS_EDIT_GET_MODIFIED_STATE()"
	^self geosMessage: #[110 8 2 0 1]!

editCheckTextFormatting
	"@message void MSG_SMS_EDIT_CHECK_TEXT_FORMATTING()"
	^self geosMessage: #[110 9 2 0 0]!

editHandleFormattingOutput: command
	"@message void MSG_SMS_EDIT_HANDLE_FORMATTING_OUTPUT( SMSEditFormattingCommands command )"
	^self geosMessage: #[110 10 1 0 1 0] with: command!

editGetReplyPath
	"@message SMReplyPath MSG_SMS_EDIT_GET_REPLY_PATH()"
	^self geosMessage: #[110 11 2 0 1]!

editGetTextSize
	"@message dword MSG_SMS_EDIT_GET_TEXT_SIZE()"
	^self geosMessage: #[110 12 2 0 2]!

editSetFocusToAddress
	"@message void MSG_SMS_EDIT_SET_FOCUS_TO_ADDRESS()"
	^self geosMessage: #[110 13 2 0 0]!

editAppendAddress1Text: buffer
	"@message void MSG_SMS_EDIT_APPEND_ADDRESS1_TEXT( TCHAR *buffer)"
	^self geosMessage: #[110 14 1 0 3 0] with: buffer!

editGetAddress1TextSize
	"@message dword MSG_SMS_EDIT_GET_ADDRESS1_TEXT_SIZE()"
	^self geosMessage: #[110 15 2 0 2]!

!

